<?php
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class VisualizzatoreModuloLogin extends VisualizzatoreComponente {
        private $configurazioneAspetto;
        private $impostazioni;
        
        function __construct($db) {
            parent::__construct($db);
        }
        
        function generaContenutoSezione($dati) {
            ?>
            <div id="login" class="container text-center">
                <div class="card card-container box-shadow-lite fadeInDown text-left">
                    <a href="index.php" class="text-center d-block">
                        <img class="img-fluid mb-4" src="<?php echo $this->configurazioneAspetto["logo"]; ?>" />
                    </a>

                    <?php 
                        if(isset($_GET["status"])) {
                            if($_GET["status"]==400) {
                                echo"<p class=\"alert alert-danger\">Errore: email o password errati</p>";
                            }
                            else if($_GET["status"]==410) {
                                echo"<p class=\"alert alert-danger\">Errore: il tuo account non è attivo!</p>";
                            }
                            else if($_GET["status"]==300) {
                                echo"<p class=\"alert alert-warning\">Questa email è già presente, hai perso la password?</p>";
                            }
                            else if($_GET["status"]==200) {
                                echo"<p class=\"alert alert-success\">Registrazione avvenuta, a presto :)</p>";
                            }
                        }
                        if($this->impostazioni["disattivaAccessoUtenti"]=="si") {
                            echo"<p class=\"alert alert-warning\">{$this->impostazioni["messaggioAccessoDisattivato"]}</p>";
                        } 
                    ?>
                    <div class="mb-2"><?=  $dati["testo"]  ?></div>
                    <form name="formLogin" action="utenti/login.php" method="post">
                        <div class="form-group">
                            <input type="email" name="email" id="inputEmail" class="form-control" placeholder="Indirizzo email" required autofocus>
                        </div>
                        <div class="form-group">
                            <input type="password" name="password" id="password" class="form-control" required />
                        </div>

                        <input type="text" class="d-none" name="tokenSicurezza" <?php echo"value=\"{$_SESSION["tokenSicurezza"]}\""; ?> >

                        <?php
                            if($this->impostazioni["disattivaAccessoUtenti"]!="si") {
                        ?>
                                <button class="btn btn-primary btn-block" type="submit">Login</button>
                        <?php 
                                if($this->impostazioni["accessoFacebook"]=="si") {
                                    include "include/facebookSdk.php";
                        ?>

                                    <fb:login-button scope="public_profile,email" onlogin="checkLoginState();">
                                    </fb:login-button>

                                    <div id="status">
                                    </div>
                        <?php 
                                }
                      
                                if($this->impostazioni["registrazioneUtenti"]=="si") {
                                   $paginaRegistrazione     = parent::getDb()->leggiSingolaRiga("geecAd_contenuti",$this->impostazioni["paginaRegistrazione"]);
                                   $linkPaginaRegistrazione = GeneratoreUrl::creaUrlContenuto($paginaRegistrazione, $this->impostazioni["ottimizzazioneUrl"], $this->impostazioni["urlPiattaforma"]);
                        ?>
                               <a href="<?php echo $linkPaginaRegistrazione ?>" class="btn btn-outline-primary btn-block" >Registrati</a>
                        <?php
                                }
                             
                                $paginaRecuperoPassword     = parent::getDb()->leggiSingolaRiga("geecAd_contenuti",$this->impostazioni["paginaRecuperoPassword"]);
                                $linkPaginaRecuperoPassword = GeneratoreUrl::creaUrlContenuto($paginaRecuperoPassword, $this->impostazioni["ottimizzazioneUrl"], $this->impostazioni["urlPiattaforma"]);
                        ?>
                                <a class="mt-2 d-block" href="<?php echo $linkPaginaRecuperoPassword ?>">Password dimenticata?</a>
                        <?php 
                            }
                        ?>
                    </form><!-- /form -->

                </div>
            </div>
            <?php
        }
        
        // getter & setter
        public function getConfigurazioneAspetto() {
            return $this->configurazioneAspetto;
        }

        public function getImpostazioni() {
            return $this->impostazioni;
        }

        public function setConfigurazioneAspetto($configurazioneAspetto) {
            $this->configurazioneAspetto = $configurazioneAspetto;
        }

        public function setImpostazioni($impostazioni) {
            $this->impostazioni = $impostazioni;
        }

    }
